<?php

namespace App\Modules\Finance\Migrations\AssetAttachment;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssetAttachment extends Model 
{

    protected $table = 'asset_attachments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function asset()
    {
        return $this->belongsTo('Asset', 'asset_id');
    }

}